/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
#include <termios.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <jni.h>
#include <stdio.h> 
#include <sys/stat.h> 
#include <stdlib.h>     

/* This is a trivial JNI example where we use a native method
 * to return a new VM String. See the corresponding Java source
 * file located at:
 *
 */
#include "android/log.h"
static const char *TAG="ReaderAndroid_SO";
#define LOGI(fmt, args...) __android_log_print(ANDROID_LOG_INFO,  TAG, fmt, ##args)
#define LOGD(fmt, args...) __android_log_print(ANDROID_LOG_DEBUG, TAG, fmt, ##args)
#define LOGE(fmt, args...) __android_log_print(ANDROID_LOG_ERROR, TAG, fmt, ##args)

#define OK  0
#define FAIL -1
#define ERROR_NotOpen 3
#define ERROR_timeOver 4
#define ERROR_Address 5
#define ERROR_Xor  7
#define ERROR_Para 10



#define STX 0XAA
#define ETX 0XBB
#define DLE 0X10

#define MaxAddress		255	//API max. address define   old: 4096
#define MaxTime			3	//Retry to send out data times when not reply
#define WaitReceive 	100	//After transmit waitting receiver frist data
#define MaxPage			12


//Define ISO14443 A Commands
#define  CMD_MF_Request              0x03  //Requst card  REQA 
#define  CMD_MF_Read                 0x20 
#define  CMD_MF_Write                0x21
#define  CMD_MF_InitVal              0x22
#define  CMD_MF_Dec                  0x23
#define  CMD_MF_Inc                  0x24
#define  CMD_MF_GET_SNR              0x25
#define  CMD_MF_Value                0x26    
#define  CMD_MF_PowerOn              0x27   
#define  CMD_ISO14443_TypeA_Transfer 0x28   
#define  CMD_MF_RST_Antenna          0x29   
#define  CMD_MF_Copy_Block           0x2A     
#define  CMD_MF_Auth                 0x2B

//Define CPU Card Commands
#define	 CMD_CPU_RATS				 0x27
#define  CMD_CPU_APDU				 0x28
#define  CMD_CPU_RST_ANT			 0x29		
 
#define INVALID_HANDLE_VALUE		 -1

void CheckControlCode(unsigned char value);
int StartTransmit(int DeviceAddress);
void TransmitData(void);
int GetRecData(int Tick);
int CheckSequence(void);

int hComm=-1;
unsigned char outBuffer[512];//
unsigned char inBuffer[512];//pc
int nBytesWrite = 0; //ֽ
int nBytesRead = 0;  //pcֽ
unsigned char CheckSum = 0;



void CheckControlCode(unsigned char value)
{
	outBuffer[nBytesWrite] = value;
	CheckSum ^= value;
	nBytesWrite++;
}
///////////////////////////////////////////////////////////////////////
/**
*@breif ںַд
*@param  DeviceAddress    int   豸ַ*
*@return int     *    
*/
int StartTransmit(int DeviceAddress)
	{
	if(hComm != INVALID_HANDLE_VALUE)
	{		
		memset(&outBuffer[0],0,sizeof(outBuffer)/sizeof(unsigned char));
		memset(&inBuffer[0],0,sizeof(inBuffer)/sizeof(unsigned char));
     	outBuffer[0]=STX;
		nBytesWrite=1;
		CheckControlCode(DeviceAddress&0xff);  //%0x100
		  //CheckControlCode(0);  // transmites this byte for future used
		return(0);
	}
	return(-1);
}

/**
*@breif /УλֹͣλbufferУٷbufferе...*
*/
//////////////////////////////////////////////////////////////////////////////
void TransmitData(void) //УλֹͣλbufferУٷbufferе...
{

	CheckControlCode(CheckSum);
	outBuffer[nBytesWrite]=ETX;
	++nBytesWrite;
	tcflush(hComm,TCIOFLUSH);

	write(hComm,outBuffer,nBytesWrite);
	LOGD("write data into ttyS0");
}

/////////////////////////////////////////////////////////////////////////////////////
int CheckSequence(void) //ַУ...
{
    unsigned char address=1;
    if(inBuffer[1] != outBuffer[address])
		return(1);
    else
		return(0);
}

/**
*@breif /˿*
*@param  Tick    int  ȴʱ*
*@return int     * 
**/
int GetRecData(int Tick)
{
	unsigned char buffer[255];
	int	n, nBytesRead, count, index;
	
	n = nBytesRead = count = index = 0;
	memset(&buffer[0],0,255);
	
	while(1) {
		n = read(hComm,buffer,255);
		if(n < 1) //ȡʧ3Ϊʱ䳬ʱ
			index++;
		if((n==0 && nBytesRead==0) && index>2) 
			return 2;//ʱδ
		if(n==0 && (!nBytesRead==0)) 
			break;//δݣյ
		memcpy(inBuffer+nBytesRead*sizeof(unsigned char), buffer, n);
		nBytesRead += n;
		n = 0;
	}
	
	int i;
	LOGD("recv data %d", nBytesRead);

	for(i=1; i<(nBytesRead-1); i++)
		inBuffer[0] ^= inBuffer[i];
	inBuffer[0] ^= STX;
	if(!inBuffer[0] == 0) 
		return 1;//Ч
   
	return 0;  
}

static speed_t getBaudrate(jint baudrate)
{
	switch(baudrate) {
	case 0: return B0;
	case 50: return B50;
	case 75: return B75;
	case 110: return B110;
	case 134: return B134;
	case 150: return B150;
	case 200: return B200;
	case 300: return B300;
	case 600: return B600;
	case 1200: return B1200;
	case 1800: return B1800;
	case 2400: return B2400;
	case 4800: return B4800;
	case 9600: return B9600;
	case 19200: return B19200;
	case 38400: return B38400;
	case 57600: return B57600;
	case 115200: return B115200;
	case 230400: return B230400;
	case 460800: return B460800;
	case 500000: return B500000;
	case 576000: return B576000;
	case 921600: return B921600;
	case 1000000: return B1000000;
	case 1152000: return B1152000;
	case 1500000: return B1500000;
	case 2000000: return B2000000;
	case 2500000: return B2500000;
	case 3000000: return B3000000;
	case 3500000: return B3500000;
	case 4000000: return B4000000;
	default: return -1;
	}
}

//-----------------------------------------------
//ReaderAndroid.so
//-----------------------------------------------

/*
 * Class:     android_reader_ReaderAndroid
 * Method:    open
 * Signature: (Ljava/lang/String;I)I
 */
JNIEXPORT jint JNICALL Java_android_reader_ReaderAndroid_open
  (JNIEnv *env, jobject thiz, jstring path, jint baudrate)
{
	int fd;
	speed_t speed;
	jobject mFileDescriptor;

	/* Check arguments */
	{
		speed = getBaudrate(baudrate);
		if (speed == -1) {
			/* TODO: throw an exception */
			LOGE("Invalid baudrate");
			return -1;
		}
	}

	/* Opening device */
	{
		jboolean iscopy;
		const char *path_utf = (*env)->GetStringUTFChars(env, path, &iscopy);
		LOGD("Opening serial port %s", path_utf);
		fd = open( path_utf, O_RDWR|O_NOCTTY);//open(path_utf, O_RDWR | O_DIRECT | O_SYNC |O_NOCTTY O_NONBLOCK);
		LOGD("open() fd = %d", fd);
		(*env)->ReleaseStringUTFChars(env, path, path_utf);
		if (fd == -1)
		{
			/* Throw an exception */
			LOGE("Cannot open port");
			/* TODO: throw an exception */
			return -1;
		}
	}

	/* Configure device */
	{
		struct termios cfg;
		LOGD("Configuring serial port");
		if (tcgetattr(fd, &cfg))
		{
			LOGE("tcgetattr() failed");
			close(fd);
			/* TODO: throw an exception */
			return -1;
		}

		cfmakeraw(&cfg);
		cfsetispeed(&cfg, speed);
		cfsetospeed(&cfg, speed);
		cfg.c_cc[VMIN]=0;
		cfg.c_cc[VTIME]=3;

		if (tcsetattr(fd, TCSANOW, &cfg))
		{
			LOGE("tcsetattr() failed");
			close(fd);
			/* TODO: throw an exception */
			return -1;
		}
	}

	return fd;
}

/*
 * Class:     android_reader_ReaderAndroid
 * Method:    close
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_android_reader_ReaderAndroid_close
  (JNIEnv *env, jobject thiz,jint fd)
{	
	LOGD("close(fd = %d)", fd);
	close(fd);
}

/*
 * Class:     android_reader_ReaderAndroid
 * Method:    MFWrite
 * Signature: (IIBBB[B[B)I
 */
JNIEXPORT jint JNICALL Java_android_reader_ReaderAndroid_MFWrite
 (JNIEnv *env, jobject thiz,jint  commHandle, jint DeviceAddress,jbyte mode, jbyte blk_add, jbyte num_blk, jbyteArray key, jbyteArray buffer)
{
	LOGD("into Write Card");
    int TimeCount;
    int length;
    int WaitTick;
    int i,ret=ERROR_timeOver;
	
	if(DeviceAddress > MaxAddress || num_blk > MaxPage || num_blk <= 0x00) 
		ret=ERROR_Para;
	else
	{

		hComm = commHandle;
		jbyte * pBytebuffer=(*env)->GetByteArrayElements(env,buffer,0);
		jbyte * pByteKey=(*env)->GetByteArrayElements(env,key,0);
		length=num_blk*16;	
		for(TimeCount=0;TimeCount <MaxTime;TimeCount++)
		{
			if(!StartTransmit(DeviceAddress))//************start transmit data to device*/
			{
				CheckControlCode(length+0x0A);    //DATALENGTH
				CheckControlCode(CMD_MF_Write);
				CheckControlCode(mode);
				CheckControlCode(num_blk);
				CheckControlCode(blk_add);
				CheckControlCode(pByteKey[0]);CheckControlCode(pByteKey[1]);
				CheckControlCode(pByteKey[2]);CheckControlCode(pByteKey[3]);
				CheckControlCode(pByteKey[4]);CheckControlCode(pByteKey[5]);
			
				for(i=0;i < length;i++)
				{
					CheckControlCode(pBytebuffer[i]);
				}

				TransmitData();
				WaitTick =(WaitReceive + num_blk *WaitReceive);
				switch(GetRecData(WaitTick))//--------------------------------Decode recevied data
				{
				case 0:  //check sum success				
					if(!CheckSequence())     //include check sequence, command code
			        {							   
						if(inBuffer[3] == OK)
						{
							pByteKey[0]=inBuffer[2]-1;
							for(i = 0; i <pByteKey[0]; i++)
								pBytebuffer[i] = inBuffer[i+4];
						}
						else
							pBytebuffer[0]= inBuffer[4];
							ret=inBuffer[3];//return(inBuffer[3]);   //return status
							TimeCount=MaxTime;//Ŀ˳ѭ
			            }
					else 
						ret=ERROR_Address;//return(5);
					break;
				case 1://check sum error
					ret=ERROR_Xor;//return(7);
					break;
				case 2:
					ret=ERROR_timeOver;//return 4
				}//---------------------------------end of switch case deoce recevied data
			}//************************************end of start transmit data to device*/
			else
				ret=ERROR_NotOpen;///return(3);
		}//end of time out for loop

		(*env)->ReleaseByteArrayElements(env,key,pByteKey,0);
		(*env)->ReleaseByteArrayElements(env,buffer,pBytebuffer,0);	
	}

	LOGD("exit Write Card");
	return ret;	
}

/*
 * Class:     android_reader_ReaderAndroid
 * Method:    MFRead
 * Signature: (IIBBB[B[B)I
 */
JNIEXPORT jint JNICALL Java_android_reader_ReaderAndroid_MFRead
 (JNIEnv *env, jobject thiz,jint  commHandle, jint DeviceAddress,jbyte mode,  jbyte blk_add, jbyte num_blk, jbyteArray snr, jbyteArray buffer)
{
	LOGD("into Read Card");
    int Retry,byte_cnt;
    int StartCnt;
	int ret=ERROR_timeOver;

	if(DeviceAddress > MaxAddress || num_blk > MaxPage || num_blk <= 0x00) 
		ret=ERROR_Para;
	else
	{
		hComm = commHandle;	  
		jbyte * pBytebuffer=(*env)->GetByteArrayElements(env,buffer,0);
		jbyte * pBytesnr=(*env)->GetByteArrayElements(env,snr,0);
	  
		for(Retry=0;Retry <MaxTime; Retry++)
		{
			if(!StartTransmit(DeviceAddress))//************start transmit data to device*/
			{
				CheckControlCode(0x0A);    //DATALENGTH
				CheckControlCode(CMD_MF_Read);  //CMD 
				CheckControlCode(mode);   //ȡģʽ
				CheckControlCode(num_blk);//
				CheckControlCode(blk_add);//ĵַ
				CheckControlCode(pBytesnr[0]);CheckControlCode(pBytesnr[1]); //ֽڵԿ
				CheckControlCode(pBytesnr[2]);CheckControlCode(pBytesnr[3]);
				CheckControlCode(pBytesnr[4]);CheckControlCode(pBytesnr[5]);    //Ѿȫȫ...
			  
				TransmitData();  //УλֹͣλoutbufferУҰoutbufferͳȥ
				StartCnt =(WaitReceive + (num_blk >>4)*WaitReceive+30); //ȴʱļ
				
				switch(GetRecData(StartCnt))//------------------------Decode received data
				{
				case 0:  //check sum success
				if(CheckSequence()==0x00)     //include check sequence, command code
				{
					if(inBuffer[3] == OK)  //OK == 0;
					{
						int snL=(inBuffer[2]-1)%16;
						for(byte_cnt=0 ;byte_cnt<snL;byte_cnt++)
							pBytesnr[byte_cnt]= inBuffer[byte_cnt+4];   

						for(byte_cnt=0 ;byte_cnt < num_blk*16 ; byte_cnt++) //ݶȡ
							pBytebuffer[byte_cnt]=inBuffer[4+snL+byte_cnt]; // Ҫȡֽ
					 }
					else
						pBytebuffer[0]=inBuffer[4];
					ret=inBuffer[3];//return(inBuffer[3]);   //return status
					Retry=MaxTime;//Ŀ˳ѭ
				}
				else 
					ret=ERROR_Address;//return(5);
				break;
				case 1://check sum error
					ret=ERROR_Xor;//return(7);
					break;
				case 2:
					ret=ERROR_timeOver;//return(4)
				}//---------------------------------end of switch case deoce recevied data
			}//************************************end of start transmit data to device*/
			else
				ret=ERROR_NotOpen;///return(3);
			}//end of time out for loop
	
			(*env)->ReleaseByteArrayElements(env,buffer,pBytebuffer,0);
			(*env)->ReleaseByteArrayElements(env,snr,pBytesnr,0);
		}

	LOGD("exit read card");
	return ret;	
}

/*
 * Class:     android_reader_ReaderAndroid
 * Method:    getCardSN
 * Signature: (IIBB[B[B)I
 */
JNIEXPORT jint JNICALL Java_android_reader_ReaderAndroid_getCardSN
  (JNIEnv *env, jobject thiz,jint  commHandle,jint DeviceAddress, jbyte mode,jbyte halt,jbyteArray flag, jbyteArray buffer)
{
	LOGD("into getCardSN");
	int TimeCount ,i,ret=ERROR_timeOver;

	if(DeviceAddress > MaxAddress ) 
		ret=ERROR_Para;
	else
	{
		hComm = commHandle;
		jbyte * pBytebuffer=(*env)->GetByteArrayElements(env,buffer,0);
		jbyte * pByteFlag=(*env)->GetByteArrayElements(env,flag,0);
	
		if (mode == 0)
			mode = 0x52;
		else
			mode = 0x26;
		LOGD("getCardSN-configure");
		for(TimeCount=0;TimeCount <MaxTime;TimeCount++)
		{
			if(!StartTransmit(DeviceAddress))///************start transmit data to device*/
			{
				CheckControlCode(0x03);    //DATALENGTH
				CheckControlCode(CMD_MF_GET_SNR);	 //CMD
				CheckControlCode(mode);   //ģʽ 26 or 52
				CheckControlCode(halt);   //haltѡ  00 or 01
				TransmitData();
			
				switch(GetRecData(WaitReceive+10))//--------------------------------Decode recevied data
				{
			     case 0:  //check sum success
					 if(!CheckSequence())     //include check sequence, command code
					 {
						if (inBuffer[3]== OK)
						{
							pByteFlag[0] = inBuffer[4];
							pByteFlag[1] = inBuffer[2] - 2;
							for(i = 0; i < pByteFlag[1]; i++)
								pBytebuffer[i] = inBuffer[i+5];
						}
						else
							pBytebuffer[0] = inBuffer[4];
						
						ret=inBuffer[3];//return(inBuffer[3]);   //return status
						TimeCount=MaxTime;//Ŀ˳ѭ
					}//END the check receive byte counter
					else 
						ret=ERROR_Address;//return(5);
					break;
				case 1://check sum error
					 ret=ERROR_Xor;//return(7);
					 break;
				case 2:
					 ret=ERROR_timeOver;//return 4
				}//---------------------------------end of switch case deoce recevied data
			}//************************************end of start transmit data to device*/
			else
				ret = ERROR_NotOpen;///return(3);
		}//end of time out for loop
	
		(*env)->ReleaseByteArrayElements(env,buffer,pBytebuffer,0);
		(*env)->ReleaseByteArrayElements(env,flag,pByteFlag,0);
	}

	LOGD("exit getCardSN");
	return ret;	
}

/*********************************************************************
 * CPU Card Commands function
 *********************************************************************/

/*
 * Class:     android_reader_ReaderAndroid
 * Method:    CPU_RATS
 * Signature: (II[B[B[B)I
 */
JNIEXPORT jint JNICALL Java_android_reader_ReaderAndroid_CPU_1RATS
  (JNIEnv *env, jobject thiz, jint commHandle, jint DeviceAddress, jbyteArray Param, jbyteArray buffer, jbyteArray Retlen)
{
	LOGD("into CPU_RATS");
	int TimeCount, i, ret = ERROR_timeOver;

	if(DeviceAddress > MaxAddress ) 
		ret = ERROR_Para;
	else
	{
		hComm = commHandle;
		jbyte * pByteParam  = (*env)->GetByteArrayElements(env, Param, 0);
		jbyte * pBytebuffer = (*env)->GetByteArrayElements(env, buffer, 0);
		jbyte * pByteRetlen = (*env)->GetByteArrayElements(env, Retlen, 0);
	
		for(TimeCount = 0; TimeCount < MaxTime; TimeCount++)
		{
			if(!StartTransmit(DeviceAddress))///************start transmit data to device*/
			{
				CheckControlCode(0x03);			//DATALENGTH
				CheckControlCode(CMD_CPU_RATS);	//CMD
				CheckControlCode(pByteParam[0]);
				CheckControlCode(pByteParam[1]);
				TransmitData();
			
				switch(GetRecData(WaitReceive+10))//--------------------------------Decode recevied data
				{
			    case 0:  //check sum success
					 if(!CheckSequence())     //include check sequence, command code
					 {
						if (inBuffer[3]== OK)
						{
							pByteRetlen[0] = inBuffer[2] - 1;
							for(i = 0; i < pByteRetlen[0]; i++)
								pBytebuffer[i] = inBuffer[i + 4];
						}
						else
							pBytebuffer[0] = inBuffer[4];
						
						ret = inBuffer[3];//return(inBuffer[3]);   //return status
						TimeCount = MaxTime;//Ŀ˳ѭ
					}//END the check receive byte counter
					else 
						ret = ERROR_Address;//return(5);
					break;
				case 1://check sum error
					 ret = ERROR_Xor;//return(7);
					 break;
				case 2:
					 ret = ERROR_timeOver;//return 4
				}//---------------------------------end of switch case deoce recevied data
			}//************************************end of start transmit data to device*/
			else
				ret = ERROR_NotOpen;///return(3);
		}//end of time out for loop
	
		(*env)->ReleaseByteArrayElements(env, Param, pByteParam, 0);
		(*env)->ReleaseByteArrayElements(env, buffer, pBytebuffer, 0);
		(*env)->ReleaseByteArrayElements(env, Retlen, pByteRetlen, 0);
	}

	return ret;	
}

/*
 * Class:     android_reader_ReaderAndroid
 * Method:    CPU_APDU
 * Signature: (II[BB[B[B)I
 */
JNIEXPORT jint JNICALL Java_android_reader_ReaderAndroid_CPU_1APDU
  (JNIEnv *env, jobject thiz, jint commHandle, jint DeviceAddress, jbyteArray Param, jbyte Paramlen, jbyteArray buffer, jbyteArray Retlen)
{
	LOGD("into CPU_APDU");
	int TimeCount, i, ret = ERROR_timeOver;

	if(DeviceAddress > MaxAddress ) 
		ret = ERROR_Para;
	else
	{
		hComm = commHandle;
		jbyte * pByteParam  = (*env)->GetByteArrayElements(env, Param, 0);
		jbyte * pBytebuffer = (*env)->GetByteArrayElements(env, buffer, 0);
		jbyte * pByteRetlen = (*env)->GetByteArrayElements(env, Retlen, 0);
	
		for(TimeCount = 0; TimeCount < MaxTime; TimeCount++)
		{
			if(!StartTransmit(DeviceAddress))///************start transmit data to device*/
			{
				CheckControlCode(Paramlen + 3);	//DATALENGTH
				CheckControlCode(CMD_CPU_APDU);	//CMD
				CheckControlCode(0x00);
				CheckControlCode(Paramlen);
				for (i = 0; i < Paramlen; i++)
					CheckControlCode(pByteParam[i]);
				TransmitData();
			
				switch(GetRecData(WaitReceive+10))//--------------------------------Decode recevied data
				{
			    case 0:  //check sum success
					 if(!CheckSequence())     //include check sequence, command code
					 {
						if (inBuffer[3] == OK)
						{
							pByteRetlen[0] = inBuffer[2] - 3;
							for(i = 0; i < pByteRetlen[0]; i++)
								pBytebuffer[i] = inBuffer[i + 6];
						}
						else
							pBytebuffer[0] = inBuffer[4];
						
						ret = inBuffer[3];//return(inBuffer[3]);   //return status
						TimeCount = MaxTime;//Ŀ˳ѭ
					}//END the check receive byte counter
					else 
						ret = ERROR_Address;//return(5);
					break;
				case 1://check sum error
					 ret = ERROR_Xor;//return(7);
					 break;
				case 2:
					 ret = ERROR_timeOver;//return 4
				}//---------------------------------end of switch case deoce recevied data
			}//************************************end of start transmit data to device*/
			else
				ret = ERROR_NotOpen;///return(3);
		}//end of time out for loop
	
		(*env)->ReleaseByteArrayElements(env, Param,  pByteParam, 0);
		(*env)->ReleaseByteArrayElements(env, buffer, pBytebuffer, 0);
		(*env)->ReleaseByteArrayElements(env, Retlen, pByteRetlen, 0);
	}

	return ret;	
}

/*
 * Class:     android_reader_ReaderAndroid
 * Method:    CPU_RST_Ant
 * Signature: (II[B[B)I
 */
JNIEXPORT jint JNICALL Java_android_reader_ReaderAndroid_CPU_1RST_1Ant
  (JNIEnv *env, jobject thiz, jint commHandle, jint DeviceAddress, jbyteArray buffer, jbyteArray Retlen)
{
	LOGD("into CPU_RST_Ant");
	int TimeCount, i, ret = ERROR_timeOver;

	if(DeviceAddress > MaxAddress ) 
		ret = ERROR_Para;
	else
	{
		hComm = commHandle;
		jbyte * pBytebuffer = (*env)->GetByteArrayElements(env, buffer, 0);
		jbyte * pByteRetlen = (*env)->GetByteArrayElements(env, Retlen, 0);
	
		for(TimeCount = 0; TimeCount < MaxTime; TimeCount++)
		{
			if(!StartTransmit(DeviceAddress))///************start transmit data to device*/
			{
				CheckControlCode(0x01);	//DATALENGTH
				CheckControlCode(CMD_CPU_RST_ANT); //CMD
				TransmitData();
			
				switch(GetRecData(WaitReceive+10))//--------------------------------Decode recevied data
				{
			    case 0:  //check sum success
					 if(!CheckSequence())     //include check sequence, command code
					 {
						if (inBuffer[3] == OK)
						{
							pByteRetlen[0] = inBuffer[2] - 1;
							for(i = 0; i < pByteRetlen[0]; i++)
								pBytebuffer[i] = inBuffer[i + 4];
						}
						else
							pBytebuffer[0] = inBuffer[4];
						
						ret = inBuffer[3];//return(inBuffer[3]);   //return status
						TimeCount = MaxTime;//Ŀ˳ѭ
					}//END the check receive byte counter
					else 
						ret = ERROR_Address;//return(5);
					break;
				case 1://check sum error
					 ret = ERROR_Xor;//return(7);
					 break;
				case 2:
					 ret = ERROR_timeOver;//return 4
				}//---------------------------------end of switch case deoce recevied data
			}//************************************end of start transmit data to device*/
			else
				ret = ERROR_NotOpen;///return(3);
		}//end of time out for loop

		(*env)->ReleaseByteArrayElements(env, buffer, pBytebuffer, 0);
		(*env)->ReleaseByteArrayElements(env, Retlen, pByteRetlen, 0);
	}

	return ret;	
}